<?php
require_once 'config.php';
require_once 'database.php';

// بررسی دسترسی ادمین
session_start();

// بررسی لاگین ادمین
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    if ($_POST && isset($_POST['password'])) {
        $admin_password = $_POST['password'];
        // رمز عبور ادمین (در production باید از دیتابیس یا فایل امن خوانده شود)
        $correct_password = 'admin123'; // تغییر دهید!
        
        if ($admin_password === $correct_password) {
            $_SESSION['admin_logged_in'] = true;
        } else {
            $login_error = 'رمز عبور اشتباه است!';
        }
    }
    
    if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
        showLoginForm($login_error ?? '');
        exit;
    }
}

$db = new Database();

// پردازش عملیات ادمین
if ($_POST) {
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'update_order_status':
                updateOrderStatus($db, $_POST['order_id'], $_POST['status'], $_POST['notes'] ?? '');
                break;
            case 'update_consultation_status':
                updateConsultationStatus($db, $_POST['consultation_id'], $_POST['status'], $_POST['reply'] ?? '');
                break;
            case 'logout':
                session_destroy();
                header('Location: admin.php');
                exit;
        }
    }
}

// دریافت آمار
$stats = getAdminStats($db);
$new_orders = $db->getNewOrders();
$new_consultations = $db->getNewConsultations();

function showLoginForm($error = '') {
    ?>
    <!DOCTYPE html>
    <html lang="fa" dir="rtl">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>ورود ادمین - ربات سفارش ربات</title>
        <style>
            * { margin: 0; padding: 0; box-sizing: border-box; }
            body {
                font-family: 'Tahoma', sans-serif;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                min-height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
            }
            .login-container {
                background: white;
                border-radius: 15px;
                box-shadow: 0 20px 40px rgba(0,0,0,0.1);
                padding: 40px;
                max-width: 400px;
                width: 100%;
                text-align: center;
            }
            .login-container h1 {
                color: #333;
                margin-bottom: 30px;
            }
            .form-group {
                margin-bottom: 20px;
                text-align: right;
            }
            .form-group label {
                display: block;
                margin-bottom: 8px;
                color: #333;
                font-weight: bold;
            }
            .form-group input {
                width: 100%;
                padding: 12px 15px;
                border: 2px solid #ddd;
                border-radius: 8px;
                font-size: 16px;
            }
            .btn {
                width: 100%;
                padding: 15px;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                color: white;
                border: none;
                border-radius: 8px;
                font-size: 18px;
                font-weight: bold;
                cursor: pointer;
            }
            .error {
                background: #f8d7da;
                color: #721c24;
                padding: 12px;
                border-radius: 8px;
                margin-bottom: 20px;
            }
        </style>
    </head>
    <body>
        <div class="login-container">
            <h1>🔐 ورود ادمین</h1>
            <?php if ($error): ?>
                <div class="error"><?php echo htmlspecialchars($error); ?></div>
            <?php endif; ?>
            <form method="POST">
                <div class="form-group">
                    <label for="password">رمز عبور:</label>
                    <input type="password" id="password" name="password" required>
                </div>
                <button type="submit" class="btn">ورود</button>
            </form>
        </div>
    </body>
    </html>
    <?php
}

function getAdminStats($db) {
    $conn = $db->getConnection();
    
    // تعداد کاربران
    $users_count = $conn->query("SELECT COUNT(*) FROM users")->fetchColumn();
    
    // تعداد سفارشات
    $orders_count = $conn->query("SELECT COUNT(*) FROM orders")->fetchColumn();
    
    // تعداد سفارشات جدید
    $new_orders_count = $conn->query("SELECT COUNT(*) FROM orders WHERE status = 'pending'")->fetchColumn();
    
    // تعداد درخواست‌های مشاوره جدید
    $new_consultations_count = $conn->query("SELECT COUNT(*) FROM consultations WHERE status = 'pending'")->fetchColumn();
    
    // مجموع موجودی کاربران
    $total_balance = $conn->query("SELECT SUM(balance) FROM users")->fetchColumn() ?? 0;
    
    // مجموع تراکنش‌های موفق
    $total_transactions = $conn->query("
        SELECT SUM(amount) FROM transactions 
        WHERE status = 'completed' AND type = 'deposit'
    ")->fetchColumn() ?? 0;
    
    return [
        'users' => $users_count,
        'orders' => $orders_count,
        'new_orders' => $new_orders_count,
        'new_consultations' => $new_consultations_count,
        'total_balance' => $total_balance,
        'total_transactions' => $total_transactions
    ];
}

function updateOrderStatus($db, $order_id, $status, $notes) {
    $stmt = $db->getConnection()->prepare("
        UPDATE orders 
        SET status = ?, admin_notes = ?, updated_at = NOW() 
        WHERE id = ?
    ");
    return $stmt->execute([$status, $notes, $order_id]);
}

function updateConsultationStatus($db, $consultation_id, $status, $reply) {
    $stmt = $db->getConnection()->prepare("
        UPDATE consultations 
        SET status = ?, admin_reply = ?, updated_at = NOW() 
        WHERE id = ?
    ");
    return $stmt->execute([$status, $reply, $consultation_id]);
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>پنل ادمین - ربات سفارش ربات</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Tahoma', sans-serif;
            background: #f8f9fa;
            color: #333;
        }
        
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .header .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .header h1 {
            font-size: 24px;
        }
        
        .logout-btn {
            background: rgba(255,255,255,0.2);
            color: white;
            border: 1px solid rgba(255,255,255,0.3);
            padding: 8px 16px;
            border-radius: 5px;
            text-decoration: none;
            transition: background 0.3s;
        }
        
        .logout-btn:hover {
            background: rgba(255,255,255,0.3);
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: white;
            border-radius: 10px;
            padding: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            text-align: center;
        }
        
        .stat-card .icon {
            font-size: 40px;
            margin-bottom: 10px;
        }
        
        .stat-card .number {
            font-size: 32px;
            font-weight: bold;
            color: #667eea;
            margin-bottom: 5px;
        }
        
        .stat-card .label {
            color: #666;
            font-size: 14px;
        }
        
        .section {
            background: white;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .section h2 {
            color: #333;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #f0f0f0;
        }
        
        .table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }
        
        .table th,
        .table td {
            padding: 12px;
            text-align: right;
            border-bottom: 1px solid #eee;
        }
        
        .table th {
            background: #f8f9fa;
            font-weight: bold;
            color: #333;
        }
        
        .table tr:hover {
            background: #f8f9fa;
        }
        
        .status {
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: bold;
        }
        
        .status.pending {
            background: #fff3cd;
            color: #856404;
        }
        
        .status.processing {
            background: #d1ecf1;
            color: #0c5460;
        }
        
        .status.completed {
            background: #d4edda;
            color: #155724;
        }
        
        .status.cancelled {
            background: #f8d7da;
            color: #721c24;
        }
        
        .btn {
            padding: 6px 12px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 12px;
            margin: 2px;
        }
        
        .btn-primary {
            background: #007bff;
            color: white;
        }
        
        .btn-success {
            background: #28a745;
            color: white;
        }
        
        .btn-danger {
            background: #dc3545;
            color: white;
        }
        
        .btn-warning {
            background: #ffc107;
            color: #212529;
        }
        
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.5);
        }
        
        .modal-content {
            background: white;
            margin: 5% auto;
            padding: 20px;
            border-radius: 10px;
            width: 90%;
            max-width: 500px;
        }
        
        .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
        
        .close {
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
            color: #aaa;
        }
        
        .close:hover {
            color: #000;
        }
        
        .form-group {
            margin-bottom: 15px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        
        .form-group input,
        .form-group select,
        .form-group textarea {
            width: 100%;
            padding: 8px 12px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 14px;
        }
        
        .form-group textarea {
            height: 100px;
            resize: vertical;
        }
        
        .no-data {
            text-align: center;
            color: #666;
            padding: 40px;
            font-style: italic;
        }
        
        @media (max-width: 768px) {
            .stats-grid {
                grid-template-columns: 1fr;
            }
            
            .table {
                font-size: 12px;
            }
            
            .table th,
            .table td {
                padding: 8px 4px;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="container">
            <h1>🛠️ پنل ادمین - ربات سفارش ربات</h1>
            <form method="POST" style="display: inline;">
                <input type="hidden" name="action" value="logout">
                <button type="submit" class="logout-btn">🚪 خروج</button>
            </form>
        </div>
    </div>
    
    <div class="container">
        <!-- آمار کلی -->
        <div class="stats-grid">
            <div class="stat-card">
                <div class="icon">👥</div>
                <div class="number"><?php echo number_format($stats['users']); ?></div>
                <div class="label">تعداد کاربران</div>
            </div>
            <div class="stat-card">
                <div class="icon">📦</div>
                <div class="number"><?php echo number_format($stats['orders']); ?></div>
                <div class="label">تعداد سفارشات</div>
            </div>
            <div class="stat-card">
                <div class="icon">🆕</div>
                <div class="number"><?php echo number_format($stats['new_orders']); ?></div>
                <div class="label">سفارشات جدید</div>
            </div>
            <div class="stat-card">
                <div class="icon">💬</div>
                <div class="number"><?php echo number_format($stats['new_consultations']); ?></div>
                <div class="label">مشاوره‌های جدید</div>
            </div>
            <div class="stat-card">
                <div class="icon">💰</div>
                <div class="number"><?php echo number_format($stats['total_balance']); ?></div>
                <div class="label">مجموع موجودی (تومان)</div>
            </div>
            <div class="stat-card">
                <div class="icon">💳</div>
                <div class="number"><?php echo number_format($stats['total_transactions']); ?></div>
                <div class="label">مجموع تراکنش‌ها (تومان)</div>
            </div>
        </div>
        
        <!-- سفارشات جدید -->
        <div class="section">
            <h2>📦 سفارشات جدید</h2>
            <?php if (empty($new_orders)): ?>
                <div class="no-data">هیچ سفارش جدیدی وجود ندارد</div>
            <?php else: ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>شناسه</th>
                            <th>کاربر</th>
                            <th>نوع ربات</th>
                            <th>مبلغ</th>
                            <th>تاریخ</th>
                            <th>وضعیت</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($new_orders as $order): ?>
                            <tr>
                                <td>#<?php echo $order['id']; ?></td>
                                <td>
                                    <?php echo htmlspecialchars($order['first_name'] ?? 'نامشخص'); ?>
                                    <?php if ($order['username']): ?>
                                        <br><small>@<?php echo htmlspecialchars($order['username']); ?></small>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo htmlspecialchars($order['bot_type']); ?></td>
                                <td><?php echo number_format($order['amount']); ?> تومان</td>
                                <td><?php echo date('Y/m/d H:i', strtotime($order['created_at'])); ?></td>
                                <td>
                                    <span class="status <?php echo $order['status']; ?>">
                                        <?php 
                                        $status_text = [
                                            'pending' => 'در انتظار',
                                            'processing' => 'در حال پردازش',
                                            'completed' => 'تکمیل شده',
                                            'cancelled' => 'لغو شده'
                                        ];
                                        echo $status_text[$order['status']] ?? $order['status'];
                                        ?>
                                    </span>
                                </td>
                                <td>
                                    <button class="btn btn-primary" onclick="openOrderModal(<?php echo $order['id']; ?>, '<?php echo $order['status']; ?>', '<?php echo htmlspecialchars($order['admin_notes'] ?? ''); ?>')">
                                        ویرایش
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
        
        <!-- درخواست‌های مشاوره -->
        <div class="section">
            <h2>💬 درخواست‌های مشاوره</h2>
            <?php if (empty($new_consultations)): ?>
                <div class="no-data">هیچ درخواست مشاوره جدیدی وجود ندارد</div>
            <?php else: ?>
                <table class="table">
                    <thead>
                        <tr>
                            <th>شناسه</th>
                            <th>کاربر</th>
                            <th>موضوع</th>
                            <th>تاریخ</th>
                            <th>وضعیت</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($new_consultations as $consultation): ?>
                            <tr>
                                <td>#<?php echo $consultation['id']; ?></td>
                                <td>
                                    <?php echo htmlspecialchars($consultation['first_name'] ?? 'نامشخص'); ?>
                                    <?php if ($consultation['username']): ?>
                                        <br><small>@<?php echo htmlspecialchars($consultation['username']); ?></small>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo htmlspecialchars($consultation['subject']); ?></td>
                                <td><?php echo date('Y/m/d H:i', strtotime($consultation['created_at'])); ?></td>
                                <td>
                                    <span class="status <?php echo $consultation['status']; ?>">
                                        <?php 
                                        $status_text = [
                                            'pending' => 'در انتظار',
                                            'replied' => 'پاسخ داده شده',
                                            'closed' => 'بسته شده'
                                        ];
                                        echo $status_text[$consultation['status']] ?? $consultation['status'];
                                        ?>
                                    </span>
                                </td>
                                <td>
                                    <button class="btn btn-primary" onclick="openConsultationModal(<?php echo $consultation['id']; ?>, '<?php echo $consultation['status']; ?>', '<?php echo htmlspecialchars($consultation['description']); ?>', '<?php echo htmlspecialchars($consultation['admin_reply'] ?? ''); ?>')">
                                        مشاهده
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- مودال ویرایش سفارش -->
    <div id="orderModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3>ویرایش سفارش</h3>
                <span class="close" onclick="closeModal('orderModal')">&times;</span>
            </div>
            <form method="POST">
                <input type="hidden" name="action" value="update_order_status">
                <input type="hidden" name="order_id" id="order_id">
                
                <div class="form-group">
                    <label for="order_status">وضعیت:</label>
                    <select name="status" id="order_status" required>
                        <option value="pending">در انتظار</option>
                        <option value="processing">در حال پردازش</option>
                        <option value="completed">تکمیل شده</option>
                        <option value="cancelled">لغو شده</option>
                    </select>
                </div>
                
                <div class="form-group">
                    <label for="order_notes">یادداشت ادمین:</label>
                    <textarea name="notes" id="order_notes" placeholder="یادداشت‌های مربوط به این سفارش..."></textarea>
                </div>
                
                <button type="submit" class="btn btn-primary">ذخیره تغییرات</button>
            </form>
        </div>
    </div>
    
    <!-- مودال مشاهده مشاوره -->
    <div id="consultationModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3>مشاهده درخواست مشاوره</h3>
                <span class="close" onclick="closeModal('consultationModal')">&times;</span>
            </div>
            <form method="POST">
                <input type="hidden" name="action" value="update_consultation_status">
                <input type="hidden" name="consultation_id" id="consultation_id">
                
                <div class="form-group">
                    <label>توضیحات کاربر:</label>
                    <div id="consultation_description" style="background: #f8f9fa; padding: 10px; border-radius: 4px; margin-bottom: 15px;"></div>
                </div>
                
                <div class="form-group">
                    <label for="consultation_status">وضعیت:</label>
                    <select name="status" id="consultation_status" required>
                        <option value="pending">در انتظار</option>
                        <option value="replied">پاسخ داده شده</option>
                        <option value="closed">بسته شده</option>
                    </select>
                </div>
                
                <div class="form-group">
                    <label for="consultation_reply">پاسخ ادمین:</label>
                    <textarea name="reply" id="consultation_reply" placeholder="پاسخ خود را اینجا بنویسید..."></textarea>
                </div>
                
                <button type="submit" class="btn btn-primary">ذخیره تغییرات</button>
            </form>
        </div>
    </div>
    
    <script>
        function openOrderModal(orderId, status, notes) {
            document.getElementById('order_id').value = orderId;
            document.getElementById('order_status').value = status;
            document.getElementById('order_notes').value = notes;
            document.getElementById('orderModal').style.display = 'block';
        }
        
        function openConsultationModal(consultationId, status, description, reply) {
            document.getElementById('consultation_id').value = consultationId;
            document.getElementById('consultation_status').value = status;
            document.getElementById('consultation_description').textContent = description;
            document.getElementById('consultation_reply').value = reply;
            document.getElementById('consultationModal').style.display = 'block';
        }
        
        function closeModal(modalId) {
            document.getElementById(modalId).style.display = 'none';
        }
        
        // بستن مودال با کلیک خارج از آن
        window.onclick = function(event) {
            const orderModal = document.getElementById('orderModal');
            const consultationModal = document.getElementById('consultationModal');
            
            if (event.target === orderModal) {
                orderModal.style.display = 'none';
            }
            if (event.target === consultationModal) {
                consultationModal.style.display = 'none';
            }
        }
    </script>
</body>
</html>
