<?php
require_once 'config.php';

// بررسی دسترسی ادمین
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    die("❌ دسترسی غیرمجاز! لطفاً ابتدا وارد شوید.");
}

echo "💾 پشتیبان‌گیری از سیستم ربات تلگرام\n";
echo "====================================\n\n";

$backup_dir = 'backups/';
if (!file_exists($backup_dir)) {
    mkdir($backup_dir, 0755, true);
}

$timestamp = date('Y-m-d_H-i-s');
$backup_file = $backup_dir . 'backup_' . $timestamp . '.sql';

echo "📅 تاریخ پشتیبان‌گیری: " . date('Y/m/d H:i:s') . "\n";
echo "📁 فایل پشتیبان: $backup_file\n\n";

try {
    // اتصال به دیتابیس
    $pdo = new PDO(
        "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
        DB_USER,
        DB_PASS,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
        ]
    );
    
    echo "1️⃣ اتصال به دیتابیس...\n";
    echo "✅ اتصال موفق\n\n";
    
    // دریافت لیست جداول
    $tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
    echo "2️⃣ دریافت لیست جداول...\n";
    echo "📊 تعداد جداول: " . count($tables) . "\n";
    foreach ($tables as $table) {
        echo "   - $table\n";
    }
    echo "\n";
    
    // شروع پشتیبان‌گیری
    echo "3️⃣ شروع پشتیبان‌گیری...\n";
    
    $backup_content = "-- پشتیبان‌گیری از دیتابیس ربات تلگرام\n";
    $backup_content .= "-- تاریخ: " . date('Y/m/d H:i:s') . "\n";
    $backup_content .= "-- نسخه: 1.0\n\n";
    $backup_content .= "SET SQL_MODE = \"NO_AUTO_VALUE_ON_ZERO\";\n";
    $backup_content .= "SET AUTOCOMMIT = 0;\n";
    $backup_content .= "START TRANSACTION;\n";
    $backup_content .= "SET time_zone = \"+00:00\";\n\n";
    
    foreach ($tables as $table) {
        echo "   📄 پشتیبان‌گیری از جدول $table...\n";
        
        // ساختار جدول
        $create_table = $pdo->query("SHOW CREATE TABLE `$table`")->fetch();
        $backup_content .= "\n-- ساختار جدول `$table`\n";
        $backup_content .= "DROP TABLE IF EXISTS `$table`;\n";
        $backup_content .= $create_table['Create Table'] . ";\n\n";
        
        // داده‌های جدول
        $rows = $pdo->query("SELECT * FROM `$table`")->fetchAll();
        if (!empty($rows)) {
            $backup_content .= "-- داده‌های جدول `$table`\n";
            
            $columns = array_keys($rows[0]);
            $column_names = '`' . implode('`, `', $columns) . '`';
            
            foreach ($rows as $row) {
                $values = [];
                foreach ($row as $value) {
                    if ($value === null) {
                        $values[] = 'NULL';
                    } else {
                        $values[] = "'" . addslashes($value) . "'";
                    }
                }
                $backup_content .= "INSERT INTO `$table` ($column_names) VALUES (" . implode(', ', $values) . ");\n";
            }
            $backup_content .= "\n";
        }
    }
    
    $backup_content .= "COMMIT;\n";
    
    // ذخیره فایل پشتیبان
    if (file_put_contents($backup_file, $backup_content)) {
        echo "✅ پشتیبان‌گیری موفق\n\n";
        
        $file_size = filesize($backup_file);
        echo "📊 اطلاعات فایل پشتیبان:\n";
        echo "   📁 مسیر: $backup_file\n";
        echo "   📏 حجم: " . number_format($file_size) . " بایت\n";
        echo "   📅 تاریخ: " . date('Y/m/d H:i:s', filemtime($backup_file)) . "\n\n";
        
        // فشرده‌سازی فایل
        if (function_exists('gzopen')) {
            echo "4️⃣ فشرده‌سازی فایل...\n";
            $compressed_file = $backup_file . '.gz';
            
            $fp_in = fopen($backup_file, 'rb');
            $fp_out = gzopen($compressed_file, 'wb9');
            
            if ($fp_in && $fp_out) {
                while (!feof($fp_in)) {
                    gzwrite($fp_out, fread($fp_in, 1024 * 512));
                }
                fclose($fp_in);
                gzclose($fp_out);
                
                $compressed_size = filesize($compressed_file);
                $compression_ratio = (1 - $compressed_size / $file_size) * 100;
                
                echo "✅ فشرده‌سازی موفق\n";
                echo "   📁 فایل فشرده: $compressed_file\n";
                echo "   📏 حجم فشرده: " . number_format($compressed_size) . " بایت\n";
                echo "   📊 درصد فشرده‌سازی: " . number_format($compression_ratio, 1) . "%\n\n";
                
                // حذف فایل اصلی
                unlink($backup_file);
                echo "🗑️ فایل اصلی حذف شد\n\n";
            } else {
                echo "❌ خطا در فشرده‌سازی\n\n";
            }
        } else {
            echo "⚠️ فشرده‌سازی در دسترس نیست\n\n";
        }
        
        // لیست فایل‌های پشتیبان
        echo "5️⃣ لیست فایل‌های پشتیبان:\n";
        $backup_files = glob($backup_dir . 'backup_*.sql*');
        rsort($backup_files); // جدیدترین اول
        
        foreach ($backup_files as $file) {
            $file_size = filesize($file);
            $file_date = date('Y/m/d H:i:s', filemtime($file));
            $file_name = basename($file);
            echo "   📄 $file_name - $file_date - " . number_format($file_size) . " بایت\n";
        }
        echo "\n";
        
        // پیشنهادات
        echo "💡 پیشنهادات:\n";
        echo "=============\n";
        echo "📁 فایل‌های پشتیبان را در مکان امن نگهداری کنید\n";
        echo "🔄 پشتیبان‌گیری منظم انجام دهید\n";
        echo "🗑️ فایل‌های قدیمی را حذف کنید\n";
        echo "☁️ پشتیبان‌گیری در فضای ابری توصیه می‌شود\n";
        echo "🧪 پشتیبان‌گیری را در محیط تست بازیابی کنید\n\n";
        
        echo "✅ پشتیبان‌گیری با موفقیت انجام شد!\n";
        
    } else {
        echo "❌ خطا در ذخیره فایل پشتیبان\n";
    }
    
} catch (Exception $e) {
    echo "❌ خطا در پشتیبان‌گیری: " . $e->getMessage() . "\n";
}

echo "\n🏁 عملیات تمام شد!\n";
?>
