<?php
require_once 'config.php';
require_once 'database.php';

// بررسی پارامترهای ورودی
if (!isset($_GET['user_id']) || !isset($_GET['Status']) || !isset($_GET['Authority'])) {
    die("❌ پارامترهای ورودی نامعتبر است!");
}

$user_id = (int)$_GET['user_id'];
$status = $_GET['Status'];
$authority = $_GET['Authority'];

$db = new Database();

// دریافت اطلاعات کاربر
$user = $db->getConnection()->prepare("SELECT * FROM users WHERE id = ?");
$user->execute([$user_id]);
$user = $user->fetch();

if (!$user) {
    die("❌ کاربر یافت نشد!");
}

// دریافت اطلاعات تراکنش
$transaction = $db->getConnection()->prepare("
    SELECT * FROM transactions 
    WHERE user_id = ? AND reference_id = ? AND status = 'pending'
");
$transaction->execute([$user_id, $authority]);
$transaction = $transaction->fetch();

if (!$transaction) {
    die("❌ تراکنش یافت نشد!");
}

$result_message = "";
$success = false;

if ($status == 'OK') {
    // تایید پرداخت از زرین‌پال
    $data = [
        'merchant_id' => ZARINPAL_MERCHANT_ID,
        'amount' => $transaction['amount'],
        'authority' => $authority
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, ZARINPAL_VERIFY_URL);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Accept: application/json'
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($http_code === 200) {
        $result = json_decode($response, true);
        
        if ($result['data']['code'] == 100) {
            // پرداخت موفق
            $db->getConnection()->beginTransaction();
            
            try {
                // به‌روزرسانی موجودی کاربر
                $update_balance = $db->getConnection()->prepare("
                    UPDATE users SET balance = balance + ? WHERE id = ?
                ");
                $update_balance->execute([$transaction['amount'], $user_id]);
                
                // به‌روزرسانی وضعیت تراکنش
                $update_transaction = $db->getConnection()->prepare("
                    UPDATE transactions 
                    SET status = 'completed', reference_id = ? 
                    WHERE id = ?
                ");
                $update_transaction->execute([$result['data']['ref_id'], $transaction['id']]);
                
                $db->getConnection()->commit();
                
                $result_message = "✅ <b>پرداخت موفق!</b>\n\n";
                $result_message .= "💰 مبلغ: " . number_format($transaction['amount']) . " تومان\n";
                $result_message .= "🆔 کد پیگیری: " . $result['data']['ref_id'] . "\n";
                $result_message .= "📅 تاریخ: " . date('Y/m/d H:i') . "\n\n";
                $result_message .= "موجودی شما با موفقیت افزایش یافت!";
                
                $success = true;
                
                // ثبت لاگ
                $db->log($user_id, 'payment_success', json_encode([
                    'amount' => $transaction['amount'],
                    'ref_id' => $result['data']['ref_id']
                ]));
                
            } catch (Exception $e) {
                $db->getConnection()->rollback();
                error_log("Payment processing failed: " . $e->getMessage());
                
                $result_message = "❌ خطا در پردازش پرداخت! لطفاً با پشتیبانی تماس بگیرید.";
            }
        } else {
            // پرداخت ناموفق
            $update_transaction = $db->getConnection()->prepare("
                UPDATE transactions SET status = 'failed' WHERE id = ?
            ");
            $update_transaction->execute([$transaction['id']]);
            
            $result_message = "❌ <b>پرداخت ناموفق!</b>\n\n";
            $result_message .= "کد خطا: " . $result['data']['code'] . "\n";
            $result_message .= "توضیحات: " . ($result['errors']['message'] ?? 'نامشخص') . "\n\n";
            $result_message .= "لطفاً دوباره تلاش کنید یا با پشتیبانی تماس بگیرید.";
            
            // ثبت لاگ
            $db->log($user_id, 'payment_failed', json_encode([
                'amount' => $transaction['amount'],
                'error_code' => $result['data']['code']
            ]));
        }
    } else {
        $result_message = "❌ خطا در ارتباط با درگاه پرداخت! لطفاً با پشتیبانی تماس بگیرید.";
    }
} else {
    // کاربر از پرداخت انصراف داد
    $update_transaction = $db->getConnection()->prepare("
        UPDATE transactions SET status = 'cancelled' WHERE id = ?
    ");
    $update_transaction->execute([$transaction['id']]);
    
    $result_message = "❌ <b>پرداخت لغو شد!</b>\n\n";
    $result_message .= "شما از پرداخت انصراف دادید.\n";
    $result_message .= "در صورت تمایل می‌توانید دوباره تلاش کنید.";
    
    // ثبت لاگ
    $db->log($user_id, 'payment_cancelled', json_encode([
        'amount' => $transaction['amount']
    ]));
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>نتیجه پرداخت - ربات سفارش ربات</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Tahoma', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .container {
            background: white;
            border-radius: 15px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            padding: 40px;
            max-width: 500px;
            width: 100%;
            text-align: center;
        }
        
        .icon {
            font-size: 80px;
            margin-bottom: 20px;
        }
        
        .success .icon {
            color: #28a745;
        }
        
        .error .icon {
            color: #dc3545;
        }
        
        .message {
            font-size: 18px;
            line-height: 1.6;
            margin-bottom: 30px;
            color: #333;
        }
        
        .success .message {
            color: #155724;
        }
        
        .error .message {
            color: #721c24;
        }
        
        .buttons {
            display: flex;
            gap: 15px;
            justify-content: center;
            flex-wrap: wrap;
        }
        
        .btn {
            padding: 12px 24px;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: bold;
            text-decoration: none;
            cursor: pointer;
            transition: all 0.3s;
            display: inline-block;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
        
        .btn-secondary {
            background: #6c757d;
            color: white;
        }
        
        .btn-secondary:hover {
            background: #5a6268;
            transform: translateY(-2px);
        }
        
        .user-info {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 30px;
        }
        
        .user-info h3 {
            color: #333;
            margin-bottom: 10px;
        }
        
        .balance {
            font-size: 20px;
            font-weight: bold;
            color: #28a745;
        }
        
        .transaction-details {
            background: #e7f3ff;
            border: 1px solid #b3d9ff;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
            text-align: right;
        }
        
        .transaction-details h4 {
            color: #0066cc;
            margin-bottom: 10px;
        }
        
        .transaction-details p {
            margin-bottom: 5px;
            color: #333;
        }
        
        @media (max-width: 600px) {
            .container {
                padding: 20px;
            }
            
            .buttons {
                flex-direction: column;
            }
            
            .btn {
                width: 100%;
            }
        }
    </style>
</head>
<body>
    <div class="container <?php echo $success ? 'success' : 'error'; ?>">
        <div class="icon">
            <?php echo $success ? '✅' : '❌'; ?>
        </div>
        
        <div class="message">
            <?php echo nl2br(htmlspecialchars($result_message)); ?>
        </div>
        
        <?php if ($success): ?>
            <div class="user-info">
                <h3>👤 اطلاعات کاربر</h3>
                <p>نام: <?php echo htmlspecialchars($user['first_name'] ?? 'نامشخص'); ?></p>
                <p>موجودی جدید: <span class="balance"><?php echo number_format($user['balance'] + $transaction['amount']); ?> تومان</span></p>
            </div>
            
            <div class="transaction-details">
                <h4>📋 جزئیات تراکنش</h4>
                <p><strong>مبلغ:</strong> <?php echo number_format($transaction['amount']); ?> تومان</p>
                <p><strong>تاریخ:</strong> <?php echo date('Y/m/d H:i'); ?></p>
                <p><strong>وضعیت:</strong> موفق</p>
            </div>
        <?php endif; ?>
        
        <div class="buttons">
            <a href="https://t.me/<?php echo BOT_TOKEN; ?>" class="btn btn-primary">
                🔙 بازگشت به ربات
            </a>
            
            <?php if (!$success): ?>
                <a href="payment.php?user_id=<?php echo $user_id; ?>" class="btn btn-secondary">
                    🔄 تلاش مجدد
                </a>
            <?php endif; ?>
        </div>
    </div>
    
    <script>
        // نمایش پیام موفقیت با انیمیشن
        <?php if ($success): ?>
        setTimeout(function() {
            document.querySelector('.container').style.transform = 'scale(1.05)';
            setTimeout(function() {
                document.querySelector('.container').style.transform = 'scale(1)';
            }, 200);
        }, 500);
        <?php endif; ?>
    </script>
</body>
</html>
