<?php
require_once 'config.php';

// بررسی وجود Bot Token
if (BOT_TOKEN === 'YOUR_BOT_TOKEN_HERE') {
    die("❌ لطفاً ابتدا Bot Token را در فایل config.php تنظیم کنید!");
}

// بررسی وجود SITE_URL
if (SITE_URL === 'https://yourdomain.com') {
    die("❌ لطفاً ابتدا SITE_URL را در فایل config.php تنظیم کنید!");
}

$webhook_url = SITE_URL . '/webhook.php';
$api_url = "https://api.telegram.org/bot" . BOT_TOKEN;

echo "🤖 تنظیم Webhook ربات تلگرام\n";
echo "================================\n\n";

// دریافت اطلاعات فعلی Webhook
echo "📋 دریافت اطلاعات فعلی Webhook...\n";
$get_webhook_url = $api_url . '/getWebhookInfo';
$response = file_get_contents($get_webhook_url);
$webhook_info = json_decode($response, true);

if ($webhook_info['ok']) {
    echo "✅ Webhook فعلی: " . ($webhook_info['result']['url'] ?: 'تنظیم نشده') . "\n";
    echo "📊 تعداد پیام‌های در انتظار: " . $webhook_info['result']['pending_update_count'] . "\n";
    echo "📅 آخرین خطا: " . ($webhook_info['result']['last_error_message'] ?: 'هیچ خطایی وجود ندارد') . "\n\n";
} else {
    echo "❌ خطا در دریافت اطلاعات Webhook: " . $webhook_info['description'] . "\n\n";
}

// تنظیم Webhook جدید
echo "🔧 تنظیم Webhook جدید...\n";
echo "📍 آدرس Webhook: " . $webhook_url . "\n\n";

$set_webhook_url = $api_url . '/setWebhook';
$data = [
    'url' => $webhook_url,
    'max_connections' => 40,
    'allowed_updates' => ['message', 'callback_query']
];

$options = [
    'http' => [
        'header' => "Content-type: application/x-www-form-urlencoded\r\n",
        'method' => 'POST',
        'content' => http_build_query($data)
    ]
];

$context = stream_context_create($options);
$response = file_get_contents($set_webhook_url, false, $context);
$result = json_decode($response, true);

if ($result['ok']) {
    echo "✅ Webhook با موفقیت تنظیم شد!\n";
    echo "📝 توضیحات: " . $result['description'] . "\n\n";
} else {
    echo "❌ خطا در تنظیم Webhook: " . $result['description'] . "\n\n";
}

// تست Webhook
echo "🧪 تست Webhook...\n";
$test_url = $api_url . '/getMe';
$response = file_get_contents($test_url);
$bot_info = json_decode($response, true);

if ($bot_info['ok']) {
    echo "✅ ربات فعال است!\n";
    echo "🤖 نام ربات: " . $bot_info['result']['first_name'] . "\n";
    echo "👤 نام کاربری: @" . $bot_info['result']['username'] . "\n";
    echo "🆔 شناسه ربات: " . $bot_info['result']['id'] . "\n\n";
} else {
    echo "❌ خطا در تست ربات: " . $bot_info['description'] . "\n\n";
}

// نمایش دستورات مفید
echo "📚 دستورات مفید:\n";
echo "================\n";
echo "🔗 لینک ربات: https://t.me/" . $bot_info['result']['username'] . "\n";
echo "🌐 آدرس Webhook: " . $webhook_url . "\n";
echo "🛠️ پنل ادمین: " . SITE_URL . "/admin.php\n";
echo "💳 صفحه پرداخت: " . SITE_URL . "/payment.php\n\n";

echo "✅ تنظیمات کامل شد!\n";
echo "🎉 ربات آماده استفاده است.\n";
?>
