<?php
require_once 'config.php';
require_once 'telegram_bot.php';

// شروع session
session_start();

// بررسی method
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    die('Method Not Allowed');
}

// بررسی وجود bot token
if (BOT_TOKEN === 'YOUR_BOT_TOKEN_HERE') {
    error_log('Bot token not configured');
    http_response_code(500);
    die('Bot token not configured');
}

try {
    // ایجاد instance ربات
    $bot = new TelegramBot();
    
    // پردازش webhook
    $result = $bot->processWebhook();
    
    if ($result) {
        http_response_code(200);
        echo 'OK';
    } else {
        http_response_code(400);
        echo 'Bad Request';
    }
} catch (Exception $e) {
    error_log('Webhook processing error: ' . $e->getMessage());
    http_response_code(500);
    echo 'Internal Server Error';
}
?>
